clearvars

fig = figure

cap = 4;
formatSpec = '%.2f';
t = tiledlayout(2, 2,'TileSpacing','Compact', 'Padding', 'Compact');

load LassoTest1.mat
ax = nexttile
%subplot(2, 2, 1)

semilogx(n_all, average_size, '-b');
hold on
semilogx(n_all, average_score, '--r');
errorbar(n_all, average_size, std_size, 'b', "LineStyle", "none", "CapSize", 4)
errorbar(n_all, average_score, std_score, 'r', "LineStyle", "none", "CapSize", 4)
grid on
xlabel('$$T$$', 'interpreter', 'latex')
title('$$s = 2, d = 10$$', 'interpreter', 'latex')

load LassoTest2.mat
ax = nexttile
%subplot(2, 2, 1)

semilogx(n_all, average_size, '-b');
hold on
semilogx(n_all, average_score, '--r');
errorbar(n_all, average_size, std_size, 'b', "LineStyle", "none", "CapSize", 4)
errorbar(n_all, average_score, std_score, 'r', "LineStyle", "none", "CapSize", 4)
grid on
xlabel('$$T$$', 'interpreter', 'latex')
title('$$s = 4, d = 10$$', 'interpreter', 'latex')

load LassoTest3.mat
ax = nexttile
 semilogx(n_all, average_size, '-b');
 hold on
 semilogx(n_all, average_score, '--r');
 errorbar(n_all, average_size, std_size, 'b', "LineStyle", "none", "CapSize", 4)
 errorbar(n_all, average_score, std_score, 'r', "LineStyle", "none", "CapSize", 4)
 legend("Average estimated support size", "Probability of not detecting the support")
 grid on
 xlabel('$$T$$', 'interpreter', 'latex')
 title('$$s = 2, d = 20$$', 'interpreter', 'latex')

 load LassoTest4.mat
ax = nexttile
 semilogx(n_all, average_size, '-b');
 hold on
 semilogx(n_all, average_score, '--r');
 errorbar(n_all, average_size, std_size, 'b', "LineStyle", "none", "CapSize", 4)
 errorbar(n_all, average_score, std_score, 'r', "LineStyle", "none", "CapSize", 4)
 legend("Average estimated support size", "Probability of not detecting the support")
 grid on
 xlabel('$$T$$', 'interpreter', 'latex')
 title('$$s = 4, d = 20$$', 'interpreter', 'latex')

lg = legend(ax, "Average support size", "Probability of detection error", 'Box', 'off', 'NumColumns', 2)
lg.Layout.Tile = 'South';
